<?php

/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/

	class CommentsController extends AppController {
		var $name = 'Comments';
		var $belongsTo = array('Post');
		var $helpers = array('Captcha','Html','Form','Time','Ajax');
		var $components = array('Captcha','Email');
		
		function add() {
			if(!empty($this->data)) {
				$captcha = true;
				$anonymous_posting = false;
				// Check captcha is enabled in admin
				if(Configure::read('MyApp.captcha_use') == "yes")
				{
					if($this->Captcha->validate($this->data)) {
						$captcha = true;
					}
					else {
						$captcha = false;
					}
				}
				
				//check anonymous posting is enabled in admin
				if(Configure::read('MyApp.anonymous_posting') == "yes") {
					$anonymous_posting = true;
				}
				else {
					if($this->Auth->User('id')) {
						$anonymous_posting = true;
					}
					else {
						$anonymous_posting = false;
					}
				}
				
				if($captcha && $anonymous_posting)
				{					
					$this->Comment->set($this->data);				
					if ($this->Comment->validates()) {
					
						$this->data['Comment']['user_id'] = ($this->Auth->User('id')) ? $this->Auth->User('id') : 1;
						$this->data['Comment']['userip'] = $_SERVER['REMOTE_ADDR'];
						$this->set('is_errors','0');
						
						App::import('Sanitize');	
						
						$this->data['Comment']['comment'] = addslashes(Sanitize::html($this->data['Comment']['comment'],array('remove' => true)));
						
						if ($this->Comment->save($this->data,array('validate' => false, 'fieldList' => array('comment','userip','user_id','video_id'),'callbacks' => true))) {
							$this->set('add_errors','0');
							$this->set('comment',$this->data['Comment']['comment']);
							
							//check users posted already and send them mail
							$comments_list = $this->Comment->find('all',array('conditions' => array('Comment.video_id' => $this->data['Comment']['video_id'],'Comment.user_id <>' => $this->data['Comment']['user_id'],'Comment.user_id <>' => 1,'User.email_status' => 'active'),'fields' => array('User.username','User.email','User.id','Video.id','Video.machine_name')));
							
							foreach($comments_list as $comments_mail) {
								$this->Email->to = $comments_mail['User']['email'];
								$this->Email->subject = 'New Comment';
								$this->Email->replyTo = Configure::read('MyApp.admin_email');
								$this->Email->from = Configure::read('MyApp.mail_from_name').'<'.Configure::read('MyApp.admin_email').'>';
								$this->Email->sendAs = 'html';
								$this->Email->template = 'new_comment';
								$this->set('name', $comments_mail['User']['username']);
								$this->set('server_name', $_SERVER['SERVER_NAME']);
								$this->set('machine_content', $comments_mail['Video']['machine_name']);
								$this->Email->send();
							}							
						} else {
							$this->set('add_errors','1');
						}
					}
					else {
						$this->set('is_errors','1');
						$Post = $this->Comment->invalidFields();
						$data = compact('Post');
						$this->set('errors', compact('message', 'data'));
					}
				}
				else
				{
					$this->set('is_errors','1');
					if(!$anonymous_posting) {
						$Post = array("Register to post a comment");
						$data = compact('Post');
						$this->set('errors', compact('message', 'data'));
					}
					else {
						$Post = array("Invalid Captcha");
						$data = compact('Post');
						$this->set('errors', compact('message', 'data'));
					}
				}				
				$this->render('comment_add_ajax','ajax');
			}	
		}
		

		function admin_view($status = 'active') {
			$this->paginate = array('conditions' => array(),'limit' => Configure::read('MyApp.record_per_page'));
			$comments = $this->paginate('Comment');
			$this->set(compact('comments'));
			$this->set('path_name','comments');
		}
	
	function admin_edit($id='') {	
		if(empty($id)) {
			$this->redirect(array('controller' => 'comments','action'=>'view','admin' =>'admin'));
		}
		if(!empty($this->data)) {
			$this->Comment->set($this->data);
			if($this->Comment->validates())
			{
				$this->Comment->create();
				if($this->Comment->save($this->data)) {
					$this->Session->setFlash('Comments Editted Successfully');
				}
				else {
					$this->Session->setFlash('There is a problem in editting comments');
				}
			}
			else {
				$this->Session->setFlash('Form validation failed');
			}			
		}
		$comments = $this->data = $this->Comment->findById($id);
		$this->set(compact('comments'));
		$this->set('path_name','comments');
	}
	
	function admin_delete($id) {
		if(!$id) {
			$this->Session->setFlash('Invalid Access');
			$this->redirect(array('controller' => 'comments','action'=>'view','admin' =>'admin'));
		}
		if($this->Comment->delete($id)) {
			$this->Session->setFlash('Deleted Successfully');
		}
		else {
			$this->Session->setFlash('Comment not deleted');
		}
		$this->redirect(array('controller' => 'comments','action'=>'view','admin' =>'admin'));
	}
		
		
	}
?>